/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.nonliving;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ParticleInit;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class VoidCloudEntity
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(VoidCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final Map<Entity, Integer> affectedEntities = Maps.newHashMap();
    private int duration = 800;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusGrowth;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUuid;
    private float particleTicker;

    public VoidCloudEntity(EntityType<? extends VoidCloudEntity> entityType, Level world) {
        super(entityType, world);
        this.f_19794_ = true;
        this.setRadius(3.0f);
        this.radiusGrowth = -0.01f;
    }

    public VoidCloudEntity(Level world, double x, double y, double z) {
        this(EntityInit.VOID_CLOUD, world);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(RADIUS, (Object)Float.valueOf(0.5f));
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    public void setRadius(float radius) {
        if (!this.m_9236_().m_5776_()) {
            this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void m_8119_() {
        super.m_8119_();
        float f = this.getRadius();
        if (this.m_9236_().m_5776_()) {
            this.particleTicker += 0.024543693f;
            double angle = Math.PI * 2 * (double)this.particleTicker;
            for (float i = 1.2f; i >= 0.2f; i -= 0.1f) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleInit.VOID_CLOUD_PARTICLE, this.m_20185_() + (double)(this.getRadius() * -(i - 1.2f)) * Math.sin(angle + Math.PI * (double)i), this.m_20186_() + (double)0.4f + (double)(this.m_9236_().m_213780_().m_188501_() * 0.1f), this.m_20189_() + (double)(this.getRadius() * -(i - 1.2f)) * Math.cos(angle + Math.PI * (double)i), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleInit.VOID_CLOUD_PARTICLE, this.m_20185_() + (double)(this.getRadius() * -(i - 1.2f)) * Math.sin(angle + Math.PI * (double)i + Math.PI), this.m_20186_() + (double)0.4f + (double)(this.m_9236_().m_213780_().m_188501_() * 0.1f), this.m_20189_() + (double)(this.getRadius() * -(i - 1.2f)) * Math.cos(angle + Math.PI * (double)i + Math.PI), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.f_19797_ >= this.waitTime + this.duration) {
                this.m_146870_();
                return;
            }
            if (this.radiusGrowth != 0.0f) {
                if ((f += this.radiusGrowth) < 0.5f) {
                    this.m_146870_();
                    return;
                }
                this.setRadius(f);
            }
            if (this.f_19797_ % 5 == 0) {
                this.affectedEntities.entrySet().removeIf(entry -> this.f_19797_ >= (Integer)entry.getValue());
                List list2 = this.m_9236_().m_45976_(Player.class, this.m_20191_());
                if (!list2.isEmpty()) {
                    Iterator var27 = list2.iterator();
                    while (true) {
                        double z;
                        double y;
                        double aa;
                        if (!var27.hasNext()) {
                            return;
                        }
                        Player livingEntity = (Player)var27.next();
                        if (this.affectedEntities.containsKey(livingEntity) || !livingEntity.m_5801_() || !((aa = (y = livingEntity.m_20185_() - this.m_20185_()) * y + (z = livingEntity.m_20189_() - this.m_20189_()) * z) <= (double)(f * f))) continue;
                        this.affectedEntities.put((Entity)livingEntity, this.f_19797_ + this.reapplicationDelay);
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 50, 2, false, false, false));
                        if (this.radiusOnUse != 0.0f) {
                            if ((f += this.radiusOnUse) < 0.5f) {
                                this.m_146870_();
                                return;
                            }
                            this.setRadius(f);
                        }
                        if (this.durationOnUse == 0) continue;
                        this.duration += this.durationOnUse;
                        if (this.duration <= 0) break;
                    }
                    this.m_146870_();
                    return;
                }
            }
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUuid)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag nbt) {
        this.f_19797_ = nbt.m_128451_("Age");
        this.duration = nbt.m_128451_("Duration");
        this.waitTime = nbt.m_128451_("WaitTime");
        this.reapplicationDelay = nbt.m_128451_("ReapplicationDelay");
        this.durationOnUse = nbt.m_128451_("DurationOnUse");
        this.radiusOnUse = nbt.m_128457_("RadiusOnUse");
        this.radiusGrowth = nbt.m_128457_("RadiusPerTick");
        this.setRadius(nbt.m_128457_("Radius"));
        if (nbt.m_128403_("Owner")) {
            this.ownerUuid = nbt.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Age", this.f_19797_);
        nbt.m_128405_("Duration", this.duration);
        nbt.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        nbt.m_128405_("DurationOnUse", this.durationOnUse);
        nbt.m_128350_("RadiusOnUse", this.radiusOnUse);
        nbt.m_128350_("RadiusPerTick", this.radiusGrowth);
        nbt.m_128350_("Radius", this.getRadius());
        if (this.ownerUuid != null) {
            nbt.m_128362_("Owner", this.ownerUuid);
        }
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (RADIUS.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

